<?php

/**

 * Dashicons

 *

 */



require_once dirname( __FILE__ ) . '/font.php';



/**

 * Icon type: Dashicons

 *

 */

class OE_Icon_Picker_Type_Dashicons extends OE_Icon_Picker_Type_Font {



	/**

	 * Icon type ID

	 *

	 */

	protected $id = 'dashicons';



	/**

	 * Icon type name

	 *

	 */

	protected $name = 'Dashicons';



	/**

	 * Icon type version

	 *

	 */

	protected $version = '4.3.1';



	/**

	 * Stylesheet URI

	 *

	 */

	protected $stylesheet_uri = '';



	/**

	 * Register assets

	 *

	 */

	public function register_assets( OE_Icon_Picker_Loader $loader ) {

		$loader->add_style( $this->stylesheet_id );

	}



	/**

	 * Get icon groups

	 *

	 */

	public function get_groups() {

		$groups = array(

			array(

				'id'   => 'admin',

				'name' => __( 'Admin', 'ocean-extra' ),

			),

			array(

				'id'   => 'post-formats',

				'name' => __( 'Post Formats', 'ocean-extra' ),

			),

			array(

				'id'   => 'welcome-screen',

				'name' => __( 'Welcome Screen', 'ocean-extra' ),

			),

			array(

				'id'   => 'image-editor',

				'name' => __( 'Image Editor', 'ocean-extra' ),

			),

			array(

				'id'   => 'text-editor',

				'name' => __( 'Text Editor', 'ocean-extra' ),

			),

			array(

				'id'   => 'post',

				'name' => __( 'Post', 'ocean-extra' ),

			),

			array(

				'id'   => 'sorting',

				'name' => __( 'Sorting', 'ocean-extra' ),

			),

			array(

				'id'   => 'social',

				'name' => __( 'Social', 'ocean-extra' ),

			),

			array(

				'id'   => 'jobs',

				'name' => __( 'Jobs', 'ocean-extra' ),

			),

			array(

				'id'   => 'products',

				'name' => __( 'Internal/Products', 'ocean-extra' ),

			),

			array(

				'id'   => 'taxonomies',

				'name' => __( 'Taxonomies', 'ocean-extra' ),

			),

			array(

				'id'   => 'alerts',

				'name' => __( 'Alerts/Notifications', 'ocean-extra' ),

			),

			array(

				'id'   => 'media',

				'name' => __( 'Media', 'ocean-extra' ),

			),

			array(

				'id'   => 'misc',

				'name' => __( 'Misc./Post Types', 'ocean-extra' ),

			),

		);



		/**

		 * Filter dashicon groups

		 *

		 */

		$groups = apply_filters( 'oe_icon_picker_dashicons_groups', $groups );



		return $groups;

	}



	/**

	 * Get icon names

	 *

	 */

	public function get_items() {

		$items = array(

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-appearance',

				'name'  => __( 'Appearance', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-collapse',

				'name'  => __( 'Collapse', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-comments',

				'name'  => __( 'Comments', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-customizer',

				'name'  => __( 'Customizer', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-dashboard',

				'name'  => __( 'Dashboard', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-generic',

				'name'  => __( 'Generic', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-filter',

				'name'  => __( 'Filter', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-home',

				'name'  => __( 'Home', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-media',

				'name'  => __( 'Media', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-menu',

				'name'  => __( 'Menu', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-multisite',

				'name'  => __( 'Multisite', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-network',

				'name'  => __( 'Network', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-page',

				'name'  => __( 'Page', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-plugins',

				'name'  => __( 'Plugins', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-settings',

				'name'  => __( 'Settings', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-site',

				'name'  => __( 'Site', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-tools',

				'name'  => __( 'Tools', 'ocean-extra' ),

			),

			array(

				'group' => 'admin',

				'id'    => 'dashicons-admin-users',

				'name'  => __( 'Users', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-standard',

				'name'  => __( 'Standard', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-aside',

				'name'  => __( 'Aside', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-image',

				'name'  => __( 'Image', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-video',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-audio',

				'name'  => __( 'Audio', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-quote',

				'name'  => __( 'Quote', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-gallery',

				'name'  => __( 'Gallery', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-links',

				'name'  => __( 'Links', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-status',

				'name'  => __( 'Status', 'ocean-extra' ),

			),

			array(

				'group' => 'post-formats',

				'id'    => 'dashicons-format-chat',

				'name'  => __( 'Chat', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-add-page',

				'name'  => __( 'Add page', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-comments',

				'name'  => __( 'Comments', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-edit-page',

				'name'  => __( 'Edit page', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-learn-more',

				'name'  => __( 'Learn More', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-view-site',

				'name'  => __( 'View Site', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-widgets-menus',

				'name'  => __( 'Widgets', 'ocean-extra' ),

			),

			array(

				'group' => 'welcome-screen',

				'id'    => 'dashicons-welcome-write-blog',

				'name'  => __( 'Write Blog', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-crop',

				'name'  => __( 'Crop', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-filter',

				'name'  => __( 'Filter', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-rotate',

				'name'  => __( 'Rotate', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-rotate-left',

				'name'  => __( 'Rotate Left', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-rotate-right',

				'name'  => __( 'Rotate Right', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-flip-vertical',

				'name'  => __( 'Flip Vertical', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-image-flip-horizontal',

				'name'  => __( 'Flip Horizontal', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-undo',

				'name'  => __( 'Undo', 'ocean-extra' ),

			),

			array(

				'group' => 'image-editor',

				'id'    => 'dashicons-redo',

				'name'  => __( 'Redo', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-bold',

				'name'  => __( 'Bold', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-italic',

				'name'  => __( 'Italic', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-ul',

				'name'  => __( 'Unordered List', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-ol',

				'name'  => __( 'Ordered List', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-quote',

				'name'  => __( 'Quote', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-alignleft',

				'name'  => __( 'Align Left', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-aligncenter',

				'name'  => __( 'Align Center', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-alignright',

				'name'  => __( 'Align Right', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-insertmore',

				'name'  => __( 'Insert More', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-spellcheck',

				'name'  => __( 'Spell Check', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-distractionfree',

				'name'  => __( 'Distraction-free', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-kitchensink',

				'name'  => __( 'Kitchensink', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-underline',

				'name'  => __( 'Underline', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-justify',

				'name'  => __( 'Justify', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-textcolor',

				'name'  => __( 'Text Color', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-paste-word',

				'name'  => __( 'Paste Word', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-paste-text',

				'name'  => __( 'Paste Text', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-removeformatting',

				'name'  => __( 'Clear Formatting', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-video',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-customchar',

				'name'  => __( 'Custom Characters', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-indent',

				'name'  => __( 'Indent', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-outdent',

				'name'  => __( 'Outdent', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-help',

				'name'  => __( 'Help', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-strikethrough',

				'name'  => __( 'Strikethrough', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-unlink',

				'name'  => __( 'Unlink', 'ocean-extra' ),

			),

			array(

				'group' => 'text-editor',

				'id'    => 'dashicons-editor-rtl',

				'name'  => __( 'RTL', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-align-left',

				'name'  => __( 'Align Left', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-align-right',

				'name'  => __( 'Align Right', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-align-center',

				'name'  => __( 'Align Center', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-align-none',

				'name'  => __( 'Align None', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-lock',

				'name'  => __( 'Lock', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-calendar',

				'name'  => __( 'Calendar', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-calendar-alt',

				'name'  => __( 'Calendar', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-hidden',

				'name'  => __( 'Hidden', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-visibility',

				'name'  => __( 'Visibility', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-post-status',

				'name'  => __( 'Post Status', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-post-trash',

				'name'  => __( 'Post Trash', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-edit',

				'name'  => __( 'Edit', 'ocean-extra' ),

			),

			array(

				'group' => 'post',

				'id'    => 'dashicons-trash',

				'name'  => __( 'Trash', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-up',

				'name'  => __( 'Arrow: Up', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-down',

				'name'  => __( 'Arrow: Down', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-left',

				'name'  => __( 'Arrow: Left', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-right',

				'name'  => __( 'Arrow: Right', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-up-alt',

				'name'  => __( 'Arrow: Up', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-down-alt',

				'name'  => __( 'Arrow: Down', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-left-alt',

				'name'  => __( 'Arrow: Left', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-right-alt',

				'name'  => __( 'Arrow: Right', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-up-alt2',

				'name'  => __( 'Arrow: Up', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-down-alt2',

				'name'  => __( 'Arrow: Down', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-left-alt2',

				'name'  => __( 'Arrow: Left', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-arrow-right-alt2',

				'name'  => __( 'Arrow: Right', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-leftright',

				'name'  => __( 'Left-Right', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-sort',

				'name'  => __( 'Sort', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-list-view',

				'name'  => __( 'List View', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-exerpt-view',

				'name'  => __( 'Excerpt View', 'ocean-extra' ),

			),

			array(

				'group' => 'sorting',

				'id'    => 'dashicons-grid-view',

				'name'  => __( 'Grid View', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-share',

				'name'  => __( 'Share', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-share-alt',

				'name'  => __( 'Share', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-share-alt2',

				'name'  => __( 'Share', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-twitter',

				'name'  => __( 'Twitter', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-rss',

				'name'  => __( 'RSS', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-email',

				'name'  => __( 'Email', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-email-alt',

				'name'  => __( 'Email', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-facebook',

				'name'  => __( 'Facebook', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-facebook-alt',

				'name'  => __( 'Facebook', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-googleplus',

				'name'  => __( 'Google+', 'ocean-extra' ),

			),

			array(

				'group' => 'social',

				'id'    => 'dashicons-networking',

				'name'  => __( 'Networking', 'ocean-extra' ),

			),

			array(

				'group' => 'jobs',

				'id'    => 'dashicons-art',

				'name'  => __( 'Art', 'ocean-extra' ),

			),

			array(

				'group' => 'jobs',

				'id'    => 'dashicons-hammer',

				'name'  => __( 'Hammer', 'ocean-extra' ),

			),

			array(

				'group' => 'jobs',

				'id'    => 'dashicons-migrate',

				'name'  => __( 'Migrate', 'ocean-extra' ),

			),

			array(

				'group' => 'jobs',

				'id'    => 'dashicons-performance',

				'name'  => __( 'Performance', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-wordpress',

				'name'  => __( 'WordPress', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-wordpress-alt',

				'name'  => __( 'WordPress', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-pressthis',

				'name'  => __( 'PressThis', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-update',

				'name'  => __( 'Update', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-screenoptions',

				'name'  => __( 'Screen Options', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-info',

				'name'  => __( 'Info', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-cart',

				'name'  => __( 'Cart', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-feedback',

				'name'  => __( 'Feedback', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-cloud',

				'name'  => __( 'Cloud', 'ocean-extra' ),

			),

			array(

				'group' => 'products',

				'id'    => 'dashicons-translation',

				'name'  => __( 'Translation', 'ocean-extra' ),

			),

			array(

				'group' => 'taxonomies',

				'id'    => 'dashicons-tag',

				'name'  => __( 'Tag', 'ocean-extra' ),

			),

			array(

				'group' => 'taxonomies',

				'id'    => 'dashicons-category',

				'name'  => __( 'Category', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-yes',

				'name'  => __( 'Yes', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-no',

				'name'  => __( 'No', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-no-alt',

				'name'  => __( 'No', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-plus',

				'name'  => __( 'Plus', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-minus',

				'name'  => __( 'Minus', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-dismiss',

				'name'  => __( 'Dismiss', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-marker',

				'name'  => __( 'Marker', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-star-filled',

				'name'  => __( 'Star: Filled', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-star-half',

				'name'  => __( 'Star: Half', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-star-empty',

				'name'  => __( 'Star: Empty', 'ocean-extra' ),

			),

			array(

				'group' => 'alerts',

				'id'    => 'dashicons-flag',

				'name'  => __( 'Flag', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-skipback',

				'name'  => __( 'Skip Back', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-back',

				'name'  => __( 'Back', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-play',

				'name'  => __( 'Play', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-pause',

				'name'  => __( 'Pause', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-forward',

				'name'  => __( 'Forward', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-skipforward',

				'name'  => __( 'Skip Forward', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-repeat',

				'name'  => __( 'Repeat', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-volumeon',

				'name'  => __( 'Volume: On', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-controls-volumeoff',

				'name'  => __( 'Volume: Off', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-archive',

				'name'  => __( 'Archive', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-audio',

				'name'  => __( 'Audio', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-code',

				'name'  => __( 'Code', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-default',

				'name'  => __( 'Default', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-document',

				'name'  => __( 'Document', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-interactive',

				'name'  => __( 'Interactive', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-spreadsheet',

				'name'  => __( 'Spreadsheet', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-text',

				'name'  => __( 'Text', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-media-video',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-playlist-audio',

				'name'  => __( 'Audio Playlist', 'ocean-extra' ),

			),

			array(

				'group' => 'media',

				'id'    => 'dashicons-playlist-video',

				'name'  => __( 'Video Playlist', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-album',

				'name'  => __( 'Album', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-analytics',

				'name'  => __( 'Analytics', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-awards',

				'name'  => __( 'Awards', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-backup',

				'name'  => __( 'Backup', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-building',

				'name'  => __( 'Building', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-businessman',

				'name'  => __( 'Businessman', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-camera',

				'name'  => __( 'Camera', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-carrot',

				'name'  => __( 'Carrot', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-chart-pie',

				'name'  => __( 'Chart: Pie', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-chart-bar',

				'name'  => __( 'Chart: Bar', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-chart-line',

				'name'  => __( 'Chart: Line', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-chart-area',

				'name'  => __( 'Chart: Area', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-desktop',

				'name'  => __( 'Desktop', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-forms',

				'name'  => __( 'Forms', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-groups',

				'name'  => __( 'Groups', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-id',

				'name'  => __( 'ID', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-id-alt',

				'name'  => __( 'ID', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-images-alt',

				'name'  => __( 'Images', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-images-alt2',

				'name'  => __( 'Images', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-index-card',

				'name'  => __( 'Index Card', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-layout',

				'name'  => __( 'Layout', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-location',

				'name'  => __( 'Location', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-location-alt',

				'name'  => __( 'Location', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-products',

				'name'  => __( 'Products', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-portfolio',

				'name'  => __( 'Portfolio', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-book',

				'name'  => __( 'Book', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-book-alt',

				'name'  => __( 'Book', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-download',

				'name'  => __( 'Download', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-upload',

				'name'  => __( 'Upload', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-clock',

				'name'  => __( 'Clock', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-lightbulb',

				'name'  => __( 'Lightbulb', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-money',

				'name'  => __( 'Money', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-palmtree',

				'name'  => __( 'Palm Tree', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-phone',

				'name'  => __( 'Phone', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-search',

				'name'  => __( 'Search', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-shield',

				'name'  => __( 'Shield', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-shield-alt',

				'name'  => __( 'Shield', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-slides',

				'name'  => __( 'Slides', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-smartphone',

				'name'  => __( 'Smartphone', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-smiley',

				'name'  => __( 'Smiley', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-sos',

				'name'  => __( 'S.O.S.', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-sticky',

				'name'  => __( 'Sticky', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-store',

				'name'  => __( 'Store', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-tablet',

				'name'  => __( 'Tablet', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-testimonial',

				'name'  => __( 'Testimonial', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-tickets-alt',

				'name'  => __( 'Tickets', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-thumbs-up',

				'name'  => __( 'Thumbs Up', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-thumbs-down',

				'name'  => __( 'Thumbs Down', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-unlock',

				'name'  => __( 'Unlock', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-vault',

				'name'  => __( 'Vault', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-video-alt',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-video-alt2',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-video-alt3',

				'name'  => __( 'Video', 'ocean-extra' ),

			),

			array(

				'group' => 'misc',

				'id'    => 'dashicons-warning',

				'name'  => __( 'Warning', 'ocean-extra' ),

			),

		);



		/**

		 * Filter dashicon items

		 *

		 */

		$items = apply_filters( 'oe_icon_picker_dashicons_items', $items );



		return $items;

	}

}

